# NTOPNG Installation
## 1. Repsitory hinzufügen & ntopng Installieren
### Contrib-Komponenten hinzufügen:
#### nano /etc/apt/sources.list:
```
deb http://deb.debian.org/debian trixie main contrib non-free non-free-firmware
apt update
```
### Abhängigkeiten installieren:
```
apt install -y lsb-release wget gnupg apt-transport-https ca-certificates
```
### Repsitory & ntopng installieren:
#### Für TRIXIE/AMD64:
```
wget https://packages.ntop.org/apt/trixie/all/apt-ntop.deb
apt install ./apt-ntop.deb
apt-get clean all
apt-get update
apt-get install pfring-dkms nprobe ntopng n2disk cento ntap
```
#### Für RASPIAN:
```
wget https://packages.ntop.org/RaspberryPI/apt-ntop.deb
dpkg -i apt-ntop.deb
apt update
apt install -y ntopng nprobe ntopng-data
```

## 2. Konfiguration
#### nano /etc/ntopng/ntopng.conf:
```
# (Mirror) Device
-i=eth0
# HTTP Port
-w=3000
# Community-Edition aktivieren (entfernt das nervige Lizenz-Popup)
--community
# HTTP komplett deaktivieren (-w ist nicht änderbar)
--http-port=0
# HTTPS Port setzen
--https-port=443
```

## 3. Promiscuous Mode für eth0
### Temporär:
```
ip link set eth0 promisc on
```
### Permanent:

#### nano /etc/systemd/system/promisc-eth0.service:
```
[Unit]
Description=Enable Promiscuous Mode on eth0
After=network.target

[Service]
Type=oneshot
ExecStart=/sbin/ip link set eth0 promisc on
RemainAfterExit=yes

[Install]
WantedBy=multi-user.target
```
#### Reload:
```
systemctl daemon-reload
systemctl enable promisc-eth0.service
systemctl start promisc-eth0.service
```

## 4. Optional: PF_RING benutzen (AMD64)
#### nano /etc/ntopng/ntopng.conf:
```
-i pf_ring:eth0
```

## Nützliche Links
`INSTALLATION:`
https://www.ntop.org/support/documentation/software-installation/
`GUIDES:`
https://www.ntop.org/guides/ntopng/
`GUTES HOWTO:`
https://www.virtualizationhowto.com/2025/11/see-everything-on-your-home-lab-network-with-ntopng/